			-------------------------------
			-- database update benchmark --
			-------------------------------
without type_check -- makes no difference

constant BATCH = 200
constant BENCH_TIME = 15

-- output device
constant LOG = 1

-- update codes
constant NEW = 1,    -- add a new account
	 UPDATE = 2, -- update an account
	 DELETE = 3  -- delete an account

-- data fields
constant NAME = 1,
	 AMOUNT = 2,
	 CODE = 3

sequence raw_data 
raw_data = {
{"George Bush", 1000, NEW},
{"Bill Clinton", 2000, NEW},
{"Brian Mulroney", 500, NEW},
{"Ross Perot", 10000, NEW},
{"Ross Perot", 0, DELETE},
{"George Bush", -30.55, UPDATE},
{"Madonna", 2500, NEW},
{"Boris Yeltsin", 100, NEW},
{"Michael Jackson", 50, NEW},
{"Peter Mansbridge", 1200, NEW},
{"Bill Clinton", +500, UPDATE},
{"Rod Stewart", 3000, NEW},
{"Boris Yeltsin", 0, DELETE},
{"Sharon Stone", 1500, NEW},
{"Clint Eastwood", 1900, NEW},
{"Madonna", 0, DELETE },
{"Sally Jessy Raphael", 750, NEW},
{"Brian Mulroney", -400, DELETE},
{"Richard Gere", 299, NEW},
{"Rod Stewart", 0, DELETE},
{"Demi Moore", 350, NEW},
{"Bruce Willis", 480, NEW},
{"Sharon Stone", +900.50, UPDATE},
{"Arsenio Hall", 300, NEW},
{"David Letterman", 450, NEW},
{"Whoopi Goldberg", 1050, NEW},
{"Clint Eastwood", +2500, UPDATE},
{"Michael Jackson", -50, UPDATE},
{"Clint Eastwood", 0, DELETE},
{"Jack Nicholson", 3000, NEW}
}

sequence database 
database = {}

procedure dump()
-- used to verify that the program has worked correctly
-- not part of timing loop
    for i = 1 to length(database) do
	printf(LOG, "%20s: %8.2f\n", database[i])
    end for
end procedure

procedure purge()
-- empty the database - free all storage
    database = {}
end procedure

procedure update(sequence data_stream)
-- process a series of transactions
    integer action, account_no
    sequence pname, record

    for i = 1 to length(data_stream) do
	record = data_stream[i]
	action = record[CODE]
	
	if action = NEW then
	    database = append(database, record[NAME..AMOUNT])

	else 
	    -- look up name
	    pname = record[NAME]
	    for j = 1 to length(database) do
		if compare(pname, database[j][NAME]) = 0 then
		    account_no = j
		    exit
		end if
	    end for

	    if action = UPDATE then
		database[account_no][AMOUNT] = database[account_no][AMOUNT] + 
					       record[AMOUNT]

	    elsif action = DELETE then
		database = database[1..account_no-1] & 
			   database[account_no+1..length(database)]
	    end if
	end if
    end for        
end procedure

atom t, cycles
puts(1, "database update benchmark ...\n\n")
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for i = 1 to BATCH do
	purge()
	update(raw_data)
    end for
    cycles = cycles + BATCH * length(raw_data)
end while
t = time() - t
printf(1, "%d transactions per second\n\n", cycles / t)
dump()

